<?php

require __DIR__ . '/../vendor/autoload.php';

use Dotenv\Dotenv;
use FastRoute\Dispatcher;
use FastRoute\RouteCollector;
use function FastRoute\simpleDispatcher;

// .env yükle
$dotenv = Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->safeLoad();

// Router yapılandırması
$dispatcher = simpleDispatcher(function (RouteCollector $r) {
    $r->addRoute('GET', '/products', ['App\Controllers\ProductController', 'index']);
    $r->addRoute('POST', '/products/create', ['App\Controllers\ProductController', 'create']);
    $r->addRoute('POST', '/sync/products', ['App\Controllers\ProductController', 'sync']);
    $r->addRoute('POST', '/sync/orders', ['App\Controllers\OrderController', 'sync']);
    $r->addRoute('POST', '/update/inventory', ['App\Controllers\ProductController', 'updateInventory']);

    // Yardımcı endpointler
    $r->addRoute('GET', '/brands', function () {
        $client = new App\Core\TrendyolClient();
        return $client->getBrands($_GET['name'] ?? null);
    });

    $r->addRoute('GET', '/categories', function () {
        $client = new App\Core\TrendyolClient();
        return $client->getCategories();
    });
});

// Request handling
$httpMethod = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

// Strip query string (?foo=bar) and decode URI
if (false !== $pos = strpos($uri, '?')) {
    $uri = substr($uri, 0, $pos);
}
$uri = rawurldecode($uri);

// trendyol-php klasöründe çalıştığımız için URI'den temizle (eğer gerekiyorsa)
$uri = str_replace('/trendyol-php/public/index.php', '', $uri);
$uri = str_replace('/trendyol-php/public', '', $uri);

$routeInfo = $dispatcher->dispatch($httpMethod, $uri);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

header('Content-Type: application/json');

switch ($routeInfo[0]) {
    case Dispatcher::NOT_FOUND:
        http_response_code(404);
        echo json_encode(['error' => '404 Not Found', 'uri' => $uri]);
        break;
    case Dispatcher::METHOD_NOT_ALLOWED:
        http_response_code(405);
        echo json_encode(['error' => '405 Method Not Allowed']);
        break;
    case Dispatcher::FOUND:
        $handler = $routeInfo[1];
        $vars = $routeInfo[2];

        try {
            if (is_callable($handler)) {
                $result = $handler($vars);
            } else {
                list($class, $method) = $handler;
                $controller = new $class();

                // Verileri birleştir (JSON, POST, GET)
                $json = file_get_contents('php://input');
                $jsonData = json_decode($json, true) ?: [];
                $params = array_merge($_GET, $_POST, $jsonData);

                // Belirli metotlar için argümanları ayır (Geriye dönük uyumluluk için)
                if ($method === 'updateInventory') {
                    $result = $controller->updateInventory(
                        $params['barcode'] ?? null,
                        $params['quantity'] ?? null,
                        $params['sale_price'] ?? ($params['salePrice'] ?? null)
                    );
                } elseif ($method === 'create') {
                    // create metodu direkt ürün listesini bekler
                    $result = $controller->create($jsonData ?: ($_POST['items'] ?? []));
                } else {
                    $result = $controller->$method($params);
                }
            }
            echo json_encode($result);
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
        break;
}
