CREATE TABLE IF NOT EXISTS products (
    id INT AUTO_INCREMENT PRIMARY KEY,
    barcode VARCHAR(100) UNIQUE NOT NULL,
    title VARCHAR(255),
    stock_code VARCHAR(100),
    quantity INT DEFAULT 0,
    sale_price DECIMAL(10, 2),
    list_price DECIMAL(10, 2),
    on_sale BOOLEAN DEFAULT TRUE,
    last_synced DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX (barcode)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_number VARCHAR(100) UNIQUE NOT NULL,
    shipment_package_id INT,
    customer_name VARCHAR(255),
    total_price DECIMAL(10, 2),
    status VARCHAR(50),
    order_date DATETIME,
    last_modified DATETIME,
    last_synced DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX (order_number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
