<?php

require __DIR__ . '/../vendor/autoload.php';

use Dotenv\Dotenv;
use App\Core\TrendyolClient;

$dotenv = Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->safeLoad();

try {
    $client = new TrendyolClient();
    echo "API Bağlantısı Test Ediliyor...\n";

    $brands = $client->getBrands('Samsung', 0, 1);
    if (!empty($brands)) {
        echo "Başarılı! Trendyol API'den marka verisi çekildi.\n";
        print_r($brands[0]);
    } else {
        echo "Hata: Veri çekilemedi veya marka bulunamadı.\n";
    }
} catch (\Exception $e) {
    echo "Hata Oluştu: " . $e->getMessage() . "\n";
}
