<?php

namespace App\Controllers;

use App\Core\Database;
use App\Core\TrendyolClient;

class OrderController
{
    private $db;
    private $tyClient;

    public function __construct()
    {
        $this->db = Database::getInstance();
        $this->tyClient = new TrendyolClient();
    }

    public function sync()
    {
        $ordersData = $this->tyClient->getOrders();
        $count = 0;

        foreach ($ordersData['content'] ?? [] as $item) {
            $orderDate = date('Y-m-d H:i:s', $item['orderDate'] / 1000);
            $lastModified = isset($item['lastModifiedDate']) ? date('Y-m-d H:i:s', $item['lastModifiedDate'] / 1000) : null;
            $customerName = ($item['customerFirstName'] ?? '') . ' ' . ($item['customerLastName'] ?? '');

            $sql = "INSERT INTO orders (order_number, shipment_package_id, customer_name, total_price, status, order_date, last_modified, last_synced) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, NOW()) 
                    ON DUPLICATE KEY UPDATE 
                    status = VALUES(status), 
                    total_price = VALUES(total_price), 
                    last_modified = VALUES(last_modified),
                    last_synced = NOW()";

            $stmt = $this->db->prepare($sql);
            $stmt->execute([
                $item['orderNumber'],
                $item['shipmentPackageId'] ?? null,
                $customerName,
                $item['totalPrice'] ?? 0,
                $item['status'] ?? '',
                $orderDate,
                $lastModified
            ]);
            $count++;
        }

        return ["message" => "$count sipariş senkronize edildi."];
    }
}
