<?php

namespace App\Controllers;

use App\Core\Database;
use App\Core\TrendyolClient;

class ProductController
{
    private $db;
    private $tyClient;

    public function __construct()
    {
        $this->db = Database::getInstance();
        $this->tyClient = new TrendyolClient();
    }

    public function index()
    {
        $stmt = $this->db->query("SELECT * FROM products");
        return $stmt->fetchAll();
    }

    public function create($products)
    {
        $response = $this->tyClient->createProducts($products);

        foreach ($products as $product) {
            $sql = "INSERT INTO products (barcode, title, stock_code, quantity, sale_price, list_price) 
                    VALUES (?, ?, ?, ?, ?, ?) 
                    ON DUPLICATE KEY UPDATE 
                    title = VALUES(title), 
                    stock_code = VALUES(stock_code), 
                    quantity = VALUES(quantity), 
                    sale_price = VALUES(sale_price), 
                    list_price = VALUES(list_price)";

            $stmt = $this->db->prepare($sql);
            $stmt->execute([
                $product['barcode'],
                $product['title'],
                $product['stockCode'],
                $product['quantity'],
                $product['salePrice'],
                $product['listPrice']
            ]);
        }

        return [
            "status" => "Success",
            "batchRequestId" => $response['batchRequestId'] ?? null
        ];
    }

    public function sync()
    {
        $productsData = $this->tyClient->getProducts();
        $count = 0;

        foreach ($productsData['content'] ?? [] as $item) {
            $sql = "INSERT INTO products (barcode, title, stock_code, quantity, sale_price, list_price, last_synced) 
                    VALUES (?, ?, ?, ?, ?, ?, NOW()) 
                    ON DUPLICATE KEY UPDATE 
                    title = VALUES(title), 
                    stock_code = VALUES(stock_code), 
                    quantity = VALUES(quantity), 
                    sale_price = VALUES(sale_price), 
                    list_price = VALUES(list_price),
                    last_synced = NOW()";

            $stmt = $this->db->prepare($sql);
            $stmt->execute([
                $item['barcode'],
                $item['title'] ?? '',
                $item['stockCode'] ?? '',
                $item['quantity'] ?? 0,
                $item['salePrice'] ?? 0,
                $item['listPrice'] ?? 0
            ]);
            $count++;
        }

        return ["message" => "$count ürün senkronize edildi."];
    }

    public function updateInventory($barcode, $quantity, $salePrice)
    {
        $items = [
            [
                "barcode" => $barcode,
                "quantity" => $quantity,
                "salePrice" => $salePrice,
                "listPrice" => $salePrice
            ]
        ];

        $response = $this->tyClient->updatePriceAndInventory($items);

        $sql = "UPDATE products SET quantity = ?, sale_price = ?, last_synced = NOW() WHERE barcode = ?";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$quantity, $salePrice, $barcode]);

        return [
            "status" => "Success",
            "batchRequestId" => $response['batchRequestId'] ?? null
        ];
    }
}
